within Modelica.Electrical.Analog.Examples.Utilities;
model Conductor "Input/output block of a conductance model"
  extends Modelica.Blocks.Icons.Block;
  parameter Modelica.SIunits.Conductance G=1 "Conductance";
  Modelica.Electrical.Analog.Basic.GeneralCurrentToVoltageAdaptor currentToVoltage1(
      use_pder=false, use_fder=false)
    annotation (Placement(transformation(extent={{-10,-10},{-30,10}})));
  Modelica.Blocks.Interfaces.RealInput i1(unit="A")
    "Current of left oneport of resistance element"
    annotation (Placement(transformation(extent={{-140,-100},{-100,
            -60}})));
  Modelica.Blocks.Interfaces.RealOutput v1(unit="V")
    "Voltage generated by the resistance element" annotation (
      Placement(transformation(extent={{-100,70},{-120,90}})));
  Modelica.Electrical.Analog.Basic.Conductor conductor(G=G) annotation (
      Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=270,
        origin={0,0})));
  Modelica.Blocks.Interfaces.RealInput i2(unit="A")
    "Current of right oneport of conduction element" annotation (
      Placement(transformation(extent={{140,-100},{100,-60}})));
  Modelica.Blocks.Interfaces.RealOutput v2(unit="V")
    "Voltage generated by the resistance element"
    annotation (Placement(transformation(extent={{100,70},{120,90}})));
  Modelica.Electrical.Analog.Basic.GeneralCurrentToVoltageAdaptor currentToVoltage2(
      use_fder=false, use_pder=false)
    annotation (Placement(transformation(extent={{10,-10},{30,10}})));
  Modelica.Electrical.Analog.Basic.Ground ground
    annotation (Placement(transformation(extent={{-10,-40},{10,-20}})));
equation

  connect(currentToVoltage1.p, v1) annotation (Line(points={{-23,8},{
          -40,8},{-40,80},{-110,80}}, color={0,0,127}));
  connect(currentToVoltage1.f, i1) annotation (Line(points={{-23,-8},
          {-40,-8},{-40,-80},{-120,-80}}, color={0,0,127}));
  connect(currentToVoltage2.f, i2) annotation (Line(points={{23,-8},{
          40,-8},{40,-80},{120,-80}}, color={0,0,127}));
  connect(v2, currentToVoltage2.p) annotation (Line(points={{110,80},
          {40,80},{40,8},{23,8}}, color={0,0,127}));
  connect(currentToVoltage1.pin_p, conductor.p) annotation (Line(points={{-18,8},
          {-10,8},{-10,10},{0,10}}, color={0,0,255}));
  connect(conductor.p, currentToVoltage2.pin_p) annotation (Line(points={{1.77636e-015,
          10},{10,10},{10,8},{18,8}}, color={0,0,255}));
  connect(currentToVoltage1.pin_n, conductor.n) annotation (Line(points={{-18,-8},
          {-10,-8},{-10,-10},{0,-10}}, color={0,0,255}));
  connect(conductor.n, currentToVoltage2.pin_n) annotation (Line(points={{0,-10},
          {10,-10},{10,-8},{18,-8}}, color={0,0,255}));
  connect(conductor.n, ground.p)
    annotation (Line(points={{0,-10},{0,-20}}, color={0,0,255}));
  annotation (Icon(coordinateSystem(
          preserveAspectRatio=false, extent={{-100,-100},{100,100}}),
        graphics={Text(
                extent={{-48,-36},{48,-68}},
                lineColor={135,135,135},
                textString="to FMU"),Text(
                extent={{-94,96},{-10,66}},
                horizontalAlignment=TextAlignment.Left,
          textString="v1"),        Text(
                extent={{-150,-114},{150,-144}},
          textString="G=%G"),      Bitmap(extent={{-88,-36},{92,56}},
            fileName="modelica://Modelica/Resources/Images/Electrical/Analog/Conductor.png"),
          Text( extent={{12,96},{96,66}},
                horizontalAlignment=TextAlignment.Right,
          textString="v2"),        Text(
                extent={{12,-62},{96,-92}},
                horizontalAlignment=TextAlignment.Right,
          textString="i2"),        Text(
                extent={{-94,-64},{-10,-94}},
                horizontalAlignment=TextAlignment.Left,
          textString="i1")}));
end Conductor;
